function [b]=udp_get_result(skt)
%function [b]=udp_get_result(skt)
% High level function for getting results from a PIC over udp
% It does not require a registry

% 5 July - 2023 - Ian Stothers
pp_commands;
if (isfield(skt,'ser')==1)
  [b]=ser_get_result(skt);
else

  if (exist('skt.bits')==1)
  %  [b]=udp_get_result(skt,add,len);
   if (skt.bits==16)
    error('16 bit version of udp_get_result not written')
   return;
  endif
endif


  oklim=50;
  timeout=0.1;

  ok=oklim;  % Allow retry
  while (ok>0)
      pbuf=uint8(UDP_GET_RESULT);
      try
         flushinput(skt.udp);
         write(skt.udp,pbuf,skt.ip,skt.port);
         flushoutput(skt.udp);
         tt=tic;
         while((skt.udp.NumBytesAvailable<GRPHSIZE)&&(toc(tt)<timeout))
         endwhile
         bb=double(read(skt.udp,skt.udp.NumBytesAvailable));
         if ((bb(1:4)==UDP_GET_RESULT_REPLY))
          if(max(size(bb))==(bb(5)+GRPHSIZE))
           b=udpgettconv(bb(13:end),bb(9),1);
           ok=-1;
          end
         end
      catch
        ok=ok-1;
      end
      if (ok==0)
        error(['udp_get_result retry time-out contacting '  skt.ip]);
        UDP_RX_ERRORS=UDP_RX_ERRORS+1;
      endif

     end  %while ok
endif
endfunction



function [b]=ser_get_result(skt)
%function [b]=ser_get_result(skt)
% High level function for getting Result from an STM32 over serial

% 9-July- 2023 - Ian Stothers
%
pp_commands;
if (exist('skt.bits')==1)
%  [b]=udp_get_result(skt,add,len);
   if (skt.bits==16)
    error('16 bit version of udp_get_result not written')
    return;
   endif
end


oklim=20;

     ok=oklim;  % Allow retry
     while (ok>0)
      pbuf=uint8(UDP_GET_RESULT);
      try
         bb=sersendget(skt,pbuf,PPHSIZE);
         if(size(bb)(2)>=4)
          if ((bb(1:4)==UDP_GET_RESULT_REPLY))
           if(max(size(bb))==(bb(5)+SPACHSIZE+4))
            b=udpgettconv(bb(10:end),bb(6),1);
            ok=-1;
           end
          end
         end
      catch
      end
      if (ok==0)
        error(['udppeek retry time-out contacting '  skt.ip]);
        UDP_RX_ERRORS=UDP_RX_ERRORS+1;
      endif
      ok=ok-1;
      pause(0.005);
     end  %while ok
endfunction
